/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.pi;

import com.ibm.hsc.cim.provider.pi.PIClusterModifier;
import com.ibm.hsc.cim.provider.pi.PIDefaultProfModifier;
import com.ibm.hsc.cim.provider.pi.PIDlparFunctions;
import com.ibm.hsc.cim.provider.pi.PIHscMProviderBase;
import com.ibm.hsc.cim.provider.pi.PIIOServer;
import com.ibm.hsc.cim.provider.pi.PILparActivateFunc;
import com.ibm.hsc.cim.provider.pi.PIOSShutdownReboot;
import com.ibm.hsc.cim.provider.pi.PIResourcesAllocationUtils;
import com.ibm.hsc.cim.provider.pi.PIVirtualPanelFunctions;
import com.ibm.hsc.cim.provider.pi.PIVirtualSCSISerialUtils;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.PIHscLockUtils;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.fsp.cmdhelpers.FspLparSrcEntry;
import com.ibm.hsc.fsp.cmdhelpers.FspLparVirtualOptiConnect;
import com.ibm.hsc.fsp.cmdhelpers.FspRequiredMemoryInfo;
import com.ibm.hsc.fsp.cmdhelpers.SrcEntry;
import com.ibm.hsc.fsp.lockmgr.FspLockHelper;
import com.ibm.hsc.lock.Lock;
import com.ibm.hsc.objmgr.cec.OmCecLongRunningTask;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.lpar.OmLparMgr;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.v50.R50ComputerSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbemcfg.GlobalConfig;

public class PIPartitionMethProv
extends PIHscMProviderBase
implements OmCecLongRunningTask {
    private final String MOF_OS400_RPA = "OS400RPA";
    private final String RPA_PARTITION = "RPA_PARTITION";
    private final String OS400_PARTITION = "OS400_PARTITION";
    public static String METHOD_POWER_OFF_PARTITION = "PowerOff";
    public static String METHOD_POWER_ON_PARTITION = "PowerOn";
    public static final String METHOD_GET_PARTITION_CURRENT_SRC = "getCurrentSRC";
    public static final String METHOD_GET_PARTITION_SRC_FROM_SEQNUM = "getSrcFromSeqNum";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMValue setDlparCapability(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws CIMException, PIHscServerException, RException {
        Object object;
        UnsignedInt32 unsignedInt32;
        UnsignedInt32 unsignedInt322;
        System.out.println("setting dlpar capability");
        if (GlobalConfig.callMethodsWithValues) {
            unsignedInt322 = (UnsignedInt32)((CIMValue)vector.elementAt(0)).getValue();
            unsignedInt32 = (UnsignedInt32)((CIMValue)vector.elementAt(1)).getValue();
        } else {
            unsignedInt322 = (UnsignedInt32)((CIMProperty)vector.elementAt(0)).getValue().getValue();
            unsignedInt32 = (UnsignedInt32)((CIMProperty)vector.elementAt(1)).getValue().getValue();
        }
        System.out.println("capValue: " + unsignedInt322);
        System.out.println("cmdValue: " + unsignedInt32);
        Vector vector3 = cIMObjectPath.getKeys();
        String string = null;
        for (int i = 0; i < vector3.size(); ++i) {
            object = (CIMProperty)vector3.elementAt(i);
            if (!object.getName().equals("Name")) continue;
            string = (String)object.getValue().getValue();
            break;
        }
        if (string == null) {
            System.out.println("cannot find partition name from cim object path:" + cIMObjectPath);
            return this.badResponse();
        }
        System.out.println("lparName: " + string);
        if (omCecMgr == null) {
            System.out.println("no cec mgr for lpar " + string);
            return this.badResponse();
        }
        OmLparMgr omLparMgr = omCecMgr.getLparMgr(string);
        if (omLparMgr != null) {
            System.out.println("calling lparmgt");
            object = PIHscLockUtils.getPartitionSubLockInstance(cIMObjectPath, 6);
            try {
                ((Lock)object).lock(1);
                omLparMgr.setDlparCapability(unsignedInt322, unsignedInt32);
            }
            finally {
                ((Lock)object).unlock();
            }
        } else {
            System.out.println("cannot find  lparmgr for: " + string);
            return this.badResponse();
        }
        return this.goodResponse();
    }

    public CIMValue getCurrentSRC(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        int n = 254;
        try {
            n = ((UnsignedInt8)omCecMgr.getObject().getProperty(R50ComputerSystem.Index_State)).intValue();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        String string = "EMPTY";
        String string2 = "EMPTY";
        UnsignedInt32 unsignedInt32 = new UnsignedInt32(0L);
        if (n == 1 || n == 17) {
            FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
            FspLparSrcEntry fspLparSrcEntry = null;
            try {
                fspLparSrcEntry = fspCmdHelper.getLPARCurrentSRC(METHOD_GET_PARTITION_CURRENT_SRC, vector, this.getLparName(cIMObjectPath));
            }
            catch (PIHscServerException pIHscServerException) {
                if (pIHscServerException.getHscExId() == null || !pIHscServerException.getHscExId().equals("2527")) {
                    pIHscServerException.printStackTrace();
                }
                throw pIHscServerException;
            }
            SrcEntry srcEntry = fspLparSrcEntry.getSrcEntry();
            unsignedInt32 = new UnsignedInt32((long)srcEntry.getSequence());
            string = srcEntry.toString();
            string2 = srcEntry.optionalDataToString();
        }
        if (GlobalConfig.callMethodsWithValues) {
            vector2.add(new CIMValue((Object)unsignedInt32, new CIMDataType(5)));
            vector2.add(new CIMValue((Object)string, new CIMDataType(9)));
            vector2.add(new CIMValue((Object)string2, new CIMDataType(9)));
        } else {
            vector2.add(new CIMProperty("seqNum", new CIMValue((Object)unsignedInt32, new CIMDataType(5))));
            vector2.add(new CIMProperty("SRCInfo", new CIMValue((Object)string, new CIMDataType(9))));
            vector2.add(new CIMProperty("optionalData", new CIMValue((Object)string2, new CIMDataType(9))));
        }
        return this.goodResponse();
    }

    public CIMValue getSrcFromSeqNum(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        UnsignedInt32 unsignedInt32;
        UnsignedInt32 unsignedInt322;
        System.out.println("^^^^^^^ GetSrcFromSeqNum <<<-----");
        boolean bl = true;
        int n = 254;
        try {
            n = ((UnsignedInt8)omCecMgr.getObject().getProperty(R50ComputerSystem.Index_State)).intValue();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (n != 1 && n != 17) {
            bl = false;
        }
        if (GlobalConfig.callMethodsWithValues) {
            unsignedInt322 = (UnsignedInt32)((CIMValue)vector.elementAt(1)).getValue();
            unsignedInt32 = (UnsignedInt32)((CIMValue)vector.elementAt(0)).getValue();
        } else {
            unsignedInt322 = (UnsignedInt32)((CIMProperty)vector.elementAt(1)).getValue().getValue();
            unsignedInt32 = (UnsignedInt32)((CIMProperty)vector.elementAt(0)).getValue().getValue();
        }
        ArrayList<FspLparSrcEntry> arrayList = new ArrayList<FspLparSrcEntry>();
        StringBuffer stringBuffer = new StringBuffer();
        FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
        FspLparSrcEntry fspLparSrcEntry = null;
        long l = unsignedInt32.longValue();
        boolean bl2 = false;
        String[] stringArray = new String[]{"EMPTY"};
        String[] stringArray2 = new String[]{"EMPTY"};
        if (bl) {
            for (long i = unsignedInt322.longValue(); i > 0L; --i) {
                try {
                    System.out.println("^^^^^ seqNumLong = " + l);
                    System.out.println("^^^^^ countLong = " + i);
                    if (l <= 0L) break;
                    fspLparSrcEntry = fspCmdHelper.getLPARSrcFromSeqNum(METHOD_GET_PARTITION_SRC_FROM_SEQNUM, vector, this.getLparName(cIMObjectPath));
                    if (fspLparSrcEntry != null) {
                        arrayList.add(fspLparSrcEntry);
                    }
                    System.out.println("^^^^^ srcList = " + arrayList);
                }
                catch (PIHscServerException pIHscServerException) {
                    boolean bl3 = true;
                    if (pIHscServerException.getHscExId() != null && pIHscServerException.getHscExId() == "2527") {
                        bl3 = false;
                    }
                    System.err.println("^^^^ Caught exception....");
                    if (3 <= Trace.LEVEL) {
                        this.trace("aplphscT", "PartitionMethProv.getSrcFromSeqNum **** Error ****");
                        if (bl3) {
                            pIHscServerException.printStackTrace();
                        }
                    }
                    HSCLogUtils.serverLog(pIHscServerException, HSCLogUtils._LPARClassLogInfo);
                    stringBuffer.append(pIHscServerException.getMessage());
                    bl2 = true;
                    break;
                }
                catch (Exception exception) {
                    System.err.println("^^^^ Caught exception....");
                    if (3 <= Trace.LEVEL) {
                        this.trace("aplphscT", "PartitionMethProv.getSrcFromSeqNum **** Error ****");
                        exception.printStackTrace();
                    }
                    HSCLogUtils.serverLog(exception, HSCLogUtils._LPARClassLogInfo);
                    stringBuffer.append(exception.getMessage());
                    bl2 = true;
                    break;
                }
                unsignedInt32 = new UnsignedInt32(--l);
                vector.setElementAt(new CIMProperty("seqNum", new CIMValue((Object)unsignedInt32)), 0);
            }
        }
        try {
            arrayList.trimToSize();
            Iterator iterator = arrayList.iterator();
            stringArray = new String[arrayList.size()];
            stringArray2 = new String[arrayList.size()];
            int n2 = 0;
            while (iterator.hasNext()) {
                SrcEntry srcEntry = ((FspLparSrcEntry)iterator.next()).getSrcEntry();
                stringArray[n2] = srcEntry.toString();
                stringArray2[n2] = srcEntry.optionalDataToString();
                ++n2;
            }
            System.out.println("outParams = " + vector2);
            if (vector2 == null) {
                vector2 = new Vector<CIMValue>();
            }
            if (GlobalConfig.callMethodsWithValues) {
                vector2.add(new CIMValue((Object)stringArray, new CIMDataType(29)));
                vector2.add(new CIMValue((Object)stringArray2, new CIMDataType(29)));
            } else {
                vector2.add((CIMValue)new CIMProperty("SRCInfo", new CIMValue((Object)stringArray, new CIMDataType(29))));
                vector2.add((CIMValue)new CIMProperty("optionalData", new CIMValue((Object)stringArray2, new CIMDataType(29))));
            }
            System.err.println("^^^^^^ outParams = " + vector2);
            System.err.println("^^^^^^ outParamsSize = " + vector2.size());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl2 = true;
        }
        if (bl2) {
            return this.badResponse();
        }
        return this.goodResponse();
    }

    public CIMValue GetSupportedVirtualPanelFunct(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        PIVirtualPanelFunctions.getSupportedVirtualPanelFunc(this.getLparName(cIMObjectPath), omCecMgr, vector2);
        return this.goodResponse();
    }

    public CIMValue ImmediateReIPL(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        PIVirtualPanelFunctions.pushVirtualPanelFunc(omCecMgr, this.getLparName(cIMObjectPath), "3");
        return this.goodResponse();
    }

    public CIMValue EmergencyPowerOff(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        PIVirtualPanelFunctions.pushVirtualPanelFunc(omCecMgr, this.getLparName(cIMObjectPath), "8");
        return this.goodResponse();
    }

    public CIMValue ForceDSTOnConsole(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        PIVirtualPanelFunctions.pushVirtualPanelFunc(omCecMgr, this.getLparName(cIMObjectPath), "21");
        return this.goodResponse();
    }

    public CIMValue DumpToLoadSrc(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
        UnsignedInt8 unsignedInt8 = (UnsignedInt8)cIMProperty.getValue().getValue();
        if (unsignedInt8.intValue() == 0) {
            PIVirtualPanelFunctions.pushVirtualPanelFunc(omCecMgr, this.getLparName(cIMObjectPath), "22");
        }
        if (unsignedInt8.intValue() == 1) {
            PIVirtualPanelFunctions.pushVirtualPanelFunc(omCecMgr, this.getLparName(cIMObjectPath), "70");
        }
        return this.goodResponse();
    }

    public CIMValue MSDIPL(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        PIVirtualPanelFunctions.pushVirtualPanelFunc(omCecMgr, this.getLparName(cIMObjectPath), "34");
        return this.goodResponse();
    }

    public CIMValue RemoteDSTEnablement(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
        UnsignedInt8 unsignedInt8 = (UnsignedInt8)cIMProperty.getValue().getValue();
        if (unsignedInt8.intValue() == 0) {
            PIVirtualPanelFunctions.pushVirtualPanelFunc(omCecMgr, this.getLparName(cIMObjectPath), "65");
        }
        if (unsignedInt8.intValue() == 1) {
            PIVirtualPanelFunctions.pushVirtualPanelFunc(omCecMgr, this.getLparName(cIMObjectPath), "66");
        }
        return this.goodResponse();
    }

    public CIMValue DiskUnitIOPOp(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
        UnsignedInt8 unsignedInt8 = (UnsignedInt8)cIMProperty.getValue().getValue();
        if (unsignedInt8.intValue() == 0) {
            PIVirtualPanelFunctions.pushVirtualPanelFunc(omCecMgr, this.getLparName(cIMObjectPath), "67");
        } else if (unsignedInt8.intValue() == 1) {
            PIVirtualPanelFunctions.pushVirtualPanelFunc(omCecMgr, this.getLparName(cIMObjectPath), "68");
        } else if (unsignedInt8.intValue() == 2) {
            PIVirtualPanelFunctions.pushVirtualPanelFunc(omCecMgr, this.getLparName(cIMObjectPath), "69");
        }
        return this.goodResponse();
    }

    public CIMValue startLparBatchMode(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        PIDlparFunctions.startLparBatchMode(omCecMgr, vector, vector2);
        return this.goodResponse();
    }

    public CIMValue commitLparBatch(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        PIDlparFunctions.commitLparBatch(omCecMgr);
        return this.goodResponse();
    }

    public Object performLongRunningTask(Object[] objectArray) throws Throwable {
        String string = (String)objectArray[0];
        CIMObjectPath cIMObjectPath = (CIMObjectPath)objectArray[1];
        OmCecMgr omCecMgr = (OmCecMgr)objectArray[2];
        Vector vector = (Vector)objectArray[3];
        Vector vector2 = (Vector)objectArray[4];
        if (string.equals("moveMem")) {
            PIDlparFunctions.moveMem(this.getCecInstance(cIMObjectPath), cIMObjectPath, omCecMgr, vector, vector2, this.m_CimomHandle);
        }
        if (string.equals("addMem")) {
            PIDlparFunctions.addMem(this.getCecInstance(cIMObjectPath), cIMObjectPath, omCecMgr, vector, vector2, this.m_CimomHandle, this.getLparInstance(cIMObjectPath));
        }
        if (string.equals("removeMem")) {
            PIDlparFunctions.removeMem(this.getCecInstance(cIMObjectPath), cIMObjectPath, omCecMgr, vector, vector2, this.m_CimomHandle);
        }
        return null;
    }

    public CIMValue moveMem(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        Lock lock = (Lock)this.getLockable("moveMem", cIMObjectPath, null);
        Object[] objectArray = new Object[]{"moveMem", cIMObjectPath, omCecMgr, vector, vector2};
        omCecMgr.doLongRunningTask(this, objectArray, lock);
        return this.goodResponse();
    }

    public CIMValue addMem(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        Lock lock = (Lock)this.getLockable("addMem", cIMObjectPath, null);
        Object[] objectArray = new Object[]{"addMem", cIMObjectPath, omCecMgr, vector, vector2};
        omCecMgr.doLongRunningTask(this, objectArray, lock);
        return this.goodResponse();
    }

    public CIMValue removeMem(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        Lock lock = (Lock)this.getLockable("removeMem", cIMObjectPath, null);
        Object[] objectArray = new Object[]{"removeMem", cIMObjectPath, omCecMgr, vector, vector2};
        omCecMgr.doLongRunningTask(this, objectArray, lock);
        return this.goodResponse();
    }

    public CIMValue varyOnMemory(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        PIDlparFunctions.varyOnMemory(omCecMgr, vector);
        return this.goodResponse();
    }

    public CIMValue varyOffMemory(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        PIDlparFunctions.varyOffMemory(omCecMgr, vector);
        return this.goodResponse();
    }

    public CIMValue OS400RPACheck(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        CIMInstance cIMInstance = this.getLparInstance(cIMObjectPath);
        short s = ((UnsignedInt8)cIMInstance.getProperty("DefinitionState").getValue().getValue()).shortValue();
        vector2.setSize(1);
        if (130 == s || 129 == s) {
            vector2.addElement(new CIMProperty("OS400RPA", new CIMValue((Object)"OS400_PARTITION", new CIMDataType(9))));
        } else {
            vector2.addElement(new CIMProperty("OS400RPA", new CIMValue((Object)"RPA_PARTITION", new CIMDataType(9))));
        }
        return this.goodResponse();
    }

    public CIMValue getMemInfo(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        PIDlparFunctions.getMemInfo(this.getCecInstance(cIMObjectPath), this.getLparInstance(cIMObjectPath), vector2, omCecMgr, cIMObjectPath, this.m_CimomHandle);
        return this.goodResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMValue SetClusterGroupID(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        int n = 64;
        FspLockHelper fspLockHelper = new FspLockHelper(omCecMgr.getFspLockMgr(), n);
        try {
            fspLockHelper.addLparLock(cIMObjectPath);
            fspLockHelper.lock();
            PIClusterModifier.changeCluster((CIMOMHandle)this.m_CimomHandle, cIMObjectPath, vector, omCecMgr, this.m_Namespace);
        }
        finally {
            fspLockHelper.unlock();
        }
        return this.goodResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMValue ChangeDefaultProfile(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        System.out.println("in ChangeDefaultProfile --> ");
        int n = 64;
        FspLockHelper fspLockHelper = new FspLockHelper(omCecMgr.getFspLockMgr(), n);
        try {
            try {
                fspLockHelper.addNvramLock(omCecMgr.getObjectId());
            }
            catch (Throwable throwable) {
                throw new PIHscServerException("025A", null);
            }
            fspLockHelper.lock();
            PIDefaultProfModifier.changeDefaultProf((CIMOMHandle)this.m_CimomHandle, cIMObjectPath, vector, omCecMgr, this.m_Namespace);
        }
        finally {
            fspLockHelper.unlock();
        }
        return this.goodResponse();
    }

    public CIMValue SetOptiConnect(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        System.out.println("\nPIPartitionMethProv.SetOptiConnect() -->\n");
        System.out.println("\nPIPartitionMethProv.SetOptiConnect() - cop = " + cIMObjectPath + "\n");
        System.out.println("\nPIPartitionMethProv.SetOptiConnect() - passed access control\n");
        CIMInstance cIMInstance = this.getLparInstance(cIMObjectPath);
        short s = ((UnsignedInt8)cIMInstance.getProperty("DefinitionState").getValue().getValue()).shortValue();
        if (130 != s && 129 != s) {
            System.out.println("\nPIPartitionMethProv.SetOptiConnect() - It's not an OS/400 partition\n");
            throw new PIHscServerException("0640", null);
        }
        System.out.println("\nPIPartitionMethProv.SetOptiConnect() - It's an OS/400 partition\n");
        String string = null;
        Boolean bl = Boolean.FALSE;
        if (GlobalConfig.callMethodsWithValues) {
            bl = (Boolean)((CIMValue)vector.elementAt(1)).getValue();
            string = (String)((CIMValue)vector.elementAt(0)).getValue();
        } else {
            bl = (Boolean)((CIMProperty)vector.elementAt(1)).getValue().getValue();
            string = (String)((CIMProperty)vector.elementAt(0)).getValue().getValue();
        }
        System.out.println("\nPIPartitionMethProv.SetOptiConnect() - poolID = " + string + ", isHSL = " + bl + "\n");
        FspLparVirtualOptiConnect fspLparVirtualOptiConnect = new FspLparVirtualOptiConnect();
        fspLparVirtualOptiConnect.setVirtualOptiConnect(bl != false ? new UnsignedInt8(0) : new UnsignedInt8(string));
        fspLparVirtualOptiConnect.setHslOptiConnect(bl != false ? new UnsignedInt8(string) : new UnsignedInt8(0));
        String string2 = (String)cIMInstance.getProperty("Name").getValue().getValue();
        omCecMgr.getCmdHelper().setLparVirtualOptiConnect(new UnsignedInt16(string2.substring(0, string2.indexOf("*"))), fspLparVirtualOptiConnect);
        if (!bl.booleanValue()) {
            CimomWrapper.setProperty(cIMInstance, "VirtualOptiConnect", new UnsignedInt8(string));
        } else {
            CimomWrapper.setProperty(cIMInstance, "HSLOptiConnect", new UnsignedInt8(string));
        }
        CimomWrapper.setInstance((CIMOMHandle)this.m_CimomHandle, cIMObjectPath, cIMInstance);
        return this.goodResponse();
    }

    public CIMValue CPULPARTask(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        this.checkParameterSize(1, vector);
        PIDlparFunctions.cpuDlparTask(cIMObjectPath, vector, vector2, omCecMgr, this.m_CimomHandle);
        return this.goodResponse();
    }

    public CIMValue addCpu(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        this.checkParameterSize(1, vector);
        PIDlparFunctions.addCpu(cIMObjectPath, vector, vector2, omCecMgr, this.m_CimomHandle);
        return this.goodResponse();
    }

    public CIMValue getProcessorData(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        PIDlparFunctions.getProcessorData(cIMObjectPath, vector2, omCecMgr, this.m_CimomHandle);
        return this.goodResponse();
    }

    public CIMValue varyOnOffProcessing(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        this.checkParameterSize(1, vector);
        PIDlparFunctions.varyOnOffProcessing(cIMObjectPath, vector, vector2, omCecMgr, this.m_CimomHandle);
        return this.goodResponse();
    }

    public CIMValue addIo(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        return PIDlparFunctions.addIo(cIMObjectPath, omCecMgr, vector, vector2, this.m_CimomHandle);
    }

    public CIMValue removeIo(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        return PIDlparFunctions.removeIo(cIMObjectPath, omCecMgr, vector, vector2, this.m_CimomHandle);
    }

    public CIMValue moveIo(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        return PIDlparFunctions.moveIo(cIMObjectPath, omCecMgr, vector, vector2, this.m_CimomHandle);
    }

    public CIMValue varyOnOffPHB(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        return PIDlparFunctions.varyOnOffPHB(cIMObjectPath, omCecMgr, vector, vector2, this.m_CimomHandle);
    }

    public CIMValue getIoSlotInfo(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        return PIDlparFunctions.getIoSlotInfo(omCecMgr, vector, vector2);
    }

    public CIMValue varyOnIo(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        return PIDlparFunctions.varyOnOffIo(omCecMgr, vector, vector2);
    }

    public CIMValue varyOffIo(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        return PIDlparFunctions.varyOnOffIo(omCecMgr, vector, vector2);
    }

    public CIMValue getVirtualIoSlotInfo(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        return PIDlparFunctions.getVirtualIoSlotInfo(omCecMgr, vector, vector2);
    }

    public CIMValue ActivatePartition(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        String string = null;
        boolean bl = false;
        System.out.println("In provider ActivatePartition");
        return this.doActivation(cIMObjectPath, omCecMgr, new UnsignedInt8(255), new UnsignedInt8(255), new UnsignedInt8(255), new UnsignedInt8(255), string);
    }

    public CIMValue addVirtualEthernet(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        return PIDlparFunctions.addVirtualEthernet(cIMObjectPath, vector, vector2, omCecMgr);
    }

    public CIMValue addVirtualSerialSCSI(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        return PIDlparFunctions.addVirtualSerialSCSI(cIMObjectPath, vector, vector2, omCecMgr);
    }

    public CIMValue removeVirtualSlots(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        return PIDlparFunctions.removeVirtualSlots(cIMObjectPath, vector, vector2, omCecMgr);
    }

    public CIMValue ActivatePartitionWithBootMode(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        this.checkParameterSize(1, vector);
        String string = null;
        UnsignedInt8 unsignedInt8 = new UnsignedInt8(255);
        try {
            unsignedInt8 = GlobalConfig.callMethodsWithValues ? (UnsignedInt8)((CIMValue)vector.get(0)).getValue() : (UnsignedInt8)((CIMProperty)vector.get(0)).getValue().getValue();
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
            throw new PIHscServerException("01FC", null);
        }
        return this.doActivation(cIMObjectPath, omCecMgr, unsignedInt8, new UnsignedInt8(255), new UnsignedInt8(255), new UnsignedInt8(255), string);
    }

    public CIMValue ActivateLparProfileWithOptionsWithHpt(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        System.out.println("ActivateLparProfileWithOptions");
        this.checkParameterSize(4, vector);
        String string = null;
        UnsignedInt8 unsignedInt8 = new UnsignedInt8(255);
        UnsignedInt8 unsignedInt82 = new UnsignedInt8(255);
        UnsignedInt8 unsignedInt83 = new UnsignedInt8(255);
        UnsignedInt8 unsignedInt84 = new UnsignedInt8(255);
        try {
            if (GlobalConfig.callMethodsWithValues) {
                string = (String)((CIMValue)vector.get(0)).getValue();
                unsignedInt8 = (UnsignedInt8)((CIMValue)vector.get(1)).getValue();
                unsignedInt82 = (UnsignedInt8)((CIMValue)vector.get(2)).getValue();
                unsignedInt83 = (UnsignedInt8)((CIMValue)vector.get(3)).getValue();
                unsignedInt84 = (UnsignedInt8)((CIMValue)vector.get(4)).getValue();
            } else {
                string = (String)((CIMProperty)vector.get(0)).getValue().getValue();
                unsignedInt8 = (UnsignedInt8)((CIMProperty)vector.get(1)).getValue().getValue();
                unsignedInt82 = (UnsignedInt8)((CIMProperty)vector.get(2)).getValue().getValue();
                unsignedInt83 = (UnsignedInt8)((CIMProperty)vector.get(3)).getValue().getValue();
                unsignedInt84 = (UnsignedInt8)((CIMProperty)vector.get(4)).getValue().getValue();
            }
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
            throw new PIHscServerException("01FC", null);
        }
        return this.doActivation(cIMObjectPath, omCecMgr, unsignedInt8, unsignedInt82, unsignedInt83, unsignedInt84, string);
    }

    public CIMValue ActivateLparProfileWithOptions(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        System.out.println("ActivateLparProfileWithOptions");
        this.checkParameterSize(4, vector);
        String string = null;
        UnsignedInt8 unsignedInt8 = new UnsignedInt8(255);
        UnsignedInt8 unsignedInt82 = new UnsignedInt8(255);
        UnsignedInt8 unsignedInt83 = new UnsignedInt8(255);
        UnsignedInt8 unsignedInt84 = new UnsignedInt8(255);
        try {
            if (GlobalConfig.callMethodsWithValues) {
                string = (String)((CIMValue)vector.get(0)).getValue();
                unsignedInt8 = (UnsignedInt8)((CIMValue)vector.get(1)).getValue();
                unsignedInt82 = (UnsignedInt8)((CIMValue)vector.get(2)).getValue();
                unsignedInt83 = (UnsignedInt8)((CIMValue)vector.get(3)).getValue();
            } else {
                string = (String)((CIMProperty)vector.get(0)).getValue().getValue();
                unsignedInt8 = (UnsignedInt8)((CIMProperty)vector.get(1)).getValue().getValue();
                unsignedInt82 = (UnsignedInt8)((CIMProperty)vector.get(2)).getValue().getValue();
                unsignedInt83 = (UnsignedInt8)((CIMProperty)vector.get(3)).getValue().getValue();
            }
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
            throw new PIHscServerException("01FC", null);
        }
        return this.doActivation(cIMObjectPath, omCecMgr, unsignedInt8, unsignedInt82, unsignedInt83, unsignedInt84, string);
    }

    public CIMValue ActivateLparProfile(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        String string = null;
        System.out.println("before check param size");
        try {
            this.checkParameterSize(1, vector);
            System.out.println("after check param size");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RuntimeException("error");
        }
        try {
            string = GlobalConfig.callMethodsWithValues ? (String)((CIMValue)vector.get(0)).getValue() : (String)((CIMProperty)vector.get(0)).getValue().getValue();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
            throw new PIHscServerException("01FC", null);
        }
        System.out.println("before doActivation");
        UnsignedInt8 unsignedInt8 = new UnsignedInt8(255);
        return this.doActivation(cIMObjectPath, omCecMgr, unsignedInt8, unsignedInt8, unsignedInt8, unsignedInt8, string);
    }

    public CIMValue EmergencyPowerOff(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2, String string) throws PIHscServerException, CIMException {
        PIVirtualPanelFunctions.powerOffPartition(cIMObjectPath, omCecMgr, this.m_CimomHandle, this.m_Namespace);
        return this.goodResponse();
    }

    public CIMValue QueryRequiredMinMemoryForMax(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        UnsignedInt32 unsignedInt32;
        Object object;
        UnsignedInt16 unsignedInt16;
        Object object2;
        CIMProperty cIMProperty;
        this.checkParameterSize(1, vector);
        FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
        try {
            Vector vector3 = cIMObjectPath.getKeys();
            cIMProperty = (CIMProperty)vector3.get(0);
            object2 = (String)cIMProperty.getValue().getValue();
            int n = ((String)object2).indexOf("*");
            unsignedInt16 = new UnsignedInt16(((String)object2).substring(0, n));
            object = (CIMProperty)vector.elementAt(0);
            unsignedInt32 = (UnsignedInt32)object.getValue().getValue();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return this.badResponse();
        }
        int n = fspCmdHelper.getLparSlotDefinitionState(unsignedInt16).intValue();
        cIMProperty = null;
        if (n == 2 || n == 1 || n == 4 || n == 3) {
            cIMProperty = new UnsignedInt8(1);
        } else if (n == 66 || n == 65) {
            cIMProperty = new UnsignedInt8(2);
        } else if (n == 130 || n == 129) {
            cIMProperty = new UnsignedInt8(3);
        }
        object2 = fspCmdHelper.getRequiredMinimumMemoryForMaximum((UnsignedInt8)cIMProperty, omCecMgr.getRecommandedHptRatio(), unsignedInt32);
        UnsignedInt32 unsignedInt322 = ((FspRequiredMemoryInfo)object2).getReqMinMemRegionsAssignedToLpar();
        object = omCecMgr.getObject();
        UnsignedInt16 unsignedInt162 = null;
        int n2 = 0;
        if (unsignedInt322 != null) {
            try {
                unsignedInt162 = (UnsignedInt16)((RObject)object).getProperty(R50ComputerSystem.Index_LMBSize);
            }
            catch (RException rException) {
                throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.LMBSize"}, rException);
            }
            if (unsignedInt162 != null) {
                n2 = unsignedInt322.intValue() * unsignedInt162.intValue();
            }
        }
        vector2.setSize(1);
        vector2.setElementAt(new CIMProperty("MinMemory", new CIMValue((Object)new UnsignedInt32((long)n2), new CIMDataType(5))), 0);
        return this.goodResponse();
    }

    public CIMValue GetServerAdapter(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        PIVirtualSCSISerialUtils.getServerAdapterData(cIMObjectPath, this.getLparName(cIMObjectPath), omCecMgr, (CIMOMHandle)this.m_CimomHandle, this.m_Namespace, vector, vector2);
        return this.goodResponse();
    }

    public CIMValue GetClientAdapter(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        PIVirtualSCSISerialUtils.getClientAdapterData(cIMObjectPath, this.getLparName(cIMObjectPath), omCecMgr, (CIMOMHandle)this.m_CimomHandle, this.m_Namespace, vector, vector2);
        return this.goodResponse();
    }

    private String getCecName(CIMObjectPath cIMObjectPath) {
        String string = this.getLparName(cIMObjectPath);
        String string2 = string.substring(string.indexOf("*") + 1);
        return string2;
    }

    private String getLparName(CIMObjectPath cIMObjectPath) {
        return this.getObjectName(cIMObjectPath);
    }

    private CIMInstance getLparInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        CIMInstance cIMInstance = null;
        cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.m_CimomHandle, cIMObjectPath, this.m_CimomHandle.getClass(cIMObjectPath, false), false);
        return cIMInstance;
    }

    private CIMInstance getCecInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        String string = this.getCecName(cIMObjectPath);
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath2 = PIResourcesAllocationUtils.constructCecPath(string, this.m_Namespace);
        cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.m_CimomHandle, cIMObjectPath2, this.m_CimomHandle.getClass(cIMObjectPath2, false), false);
        return cIMInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CIMValue doActivation(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, UnsignedInt8 unsignedInt8, UnsignedInt8 unsignedInt82, UnsignedInt8 unsignedInt83, UnsignedInt8 unsignedInt84, String string) throws PIHscServerException, CIMException {
        int n = 64;
        FspLockHelper fspLockHelper = new FspLockHelper(omCecMgr.getFspLockMgr(), n);
        try {
            try {
                fspLockHelper.addCecLock(omCecMgr.getObjectId());
            }
            catch (Throwable throwable) {
                throw new PIHscServerException("025A", null);
            }
            fspLockHelper.lock();
            CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.m_CimomHandle, cIMObjectPath, new CIMClass("IBMHSC_Partition"), false);
            if (this.tracing(2)) {
                this.trace("appahscF", "partitionInstance = " + cIMInstance);
            }
            if (cIMInstance == null) {
                System.out.println("cannot get the partition inst for cop: " + cIMObjectPath);
                throw new PIHscServerException("1586", new String[]{cIMObjectPath.toString()}, null);
            }
            String string2 = (String)cIMInstance.getProperty("Name").getValue().getValue();
            System.out.println("get partition name: " + string2);
            CIMObjectPath cIMObjectPath2 = null;
            if (string != null && string.trim().length() > 0) {
                cIMObjectPath2 = new CIMObjectPath("IBMHSC_LparProfile", this.m_Namespace);
                cIMObjectPath2.addKey("PartitionCreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
                cIMObjectPath2.addKey("PartitionName", new CIMValue((Object)string2));
                cIMObjectPath2.addKey("SettingID", new CIMValue((Object)string));
            }
            System.out.println("calling PILparActivateFunc.activatePartition: " + cIMObjectPath2);
            PILparActivateFunc.ActivateOverrideAttrs activateOverrideAttrs = new PILparActivateFunc.ActivateOverrideAttrs();
            activateOverrideAttrs.bootMode = unsignedInt8;
            activateOverrideAttrs.iplSource = unsignedInt82;
            activateOverrideAttrs.keylock = unsignedInt83;
            activateOverrideAttrs.hptRatio = unsignedInt84;
            PILparActivateFunc.activatePartition(cIMObjectPath, cIMObjectPath2, activateOverrideAttrs, omCecMgr, this.m_CimomHandle, fspLockHelper);
            CIMValue cIMValue = this.goodResponse();
            return cIMValue;
        }
        finally {
            fspLockHelper.unlock();
        }
    }

    public CIMValue PowerOff(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException, CIMException {
        PIVirtualPanelFunctions.powerOffPartition(cIMObjectPath, omCecMgr, this.m_CimomHandle, this.m_Namespace);
        return this.goodResponse();
    }

    public CIMValue OSShutdown(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException {
        PIOSShutdownReboot.osShutdownReboot(cIMObjectPath, omCecMgr, this.m_CimomHandle, this.m_Namespace, vector, vector2);
        return this.goodResponse();
    }

    public CIMValue SetLparIoPool(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException {
        Vector vector3 = GlobalConfig.callMethodsWithValues ? (Vector)((CIMValue)vector.elementAt(0)).getValue() : (Vector)((CIMProperty)vector.elementAt(0)).getValue().getValue();
        UnsignedInt16[] unsignedInt16Array = vector3.toArray(new UnsignedInt16[0]);
        String string = this.getLparName(cIMObjectPath);
        int n = Integer.parseInt(string.substring(0, string.indexOf("*")));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(n);
        omCecMgr.getCmdHelper().setLparIoPoolConfiguration(unsignedInt16, unsignedInt16Array);
        return this.goodResponse();
    }

    public CIMValue SendIOServerCMD(CIMObjectPath cIMObjectPath, OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException {
        PIIOServer.sendIOServerCmd(cIMObjectPath, omCecMgr, this.m_CimomHandle, this.m_Namespace, vector, vector2);
        return this.goodResponse();
    }
}

